\version "2.24.0"

\paper {
  between-system-padding = 0\mm
  markup-system-spacing = #'((basic-distance . 1))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 4\mm
  ragged-last-bottom=##f
  system-count = #10
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "De tine se bucură"
  %subtitle = "Cuvine-se cu adevărat"
  composer = \markup \center-column { "Gavriil Musicescu" \small 
  "(1847–1903)" }
  meter = "Moderato"
  tagline=""
}

global = {
  %#(set-global-staff-size 19)
  \key e \major
  \time 3/4
  \partial 4
  \set Staff.midiInstrument = "clarinet"
  %\autoBeamOff
}

womenWords = \lyricmode {
  De ti -- ne se bu -- cu -- ră, ce -- ea ce eşti pli -- nă de har, 
  toa -- tă făp -- tu -- ra.
  So -- bo -- rul în -- ge -- resc şi nea -- mul o -- me -- nesc, 
  Ce -- ea ce eşti bi -- se -- ri -- că sfin -- ţi -- tă 
  şi rai cu -- vân -- tă -- tor, 
  La -- u -- da fe -- cio -- ri -- ei, din ca -- re 
  Dum -- ne -- zeu, Dum -- ne -- zeu S-a în -- tru -- pat. 
  Şi Prunc, şi Prunc  S-a fă -- cut, 
  Cel ce es -- te mai 'na -- in -- te de veci, 
  Dum -- ne -- ze -- ul nos -- tru. 
  Că mi -- tra -- sul tău sca -- un L-a __ fă -- cut
  şi pân -- te -- ce -- le tău mai des -- fă -- tat 
  de -- cât __ Ce -- ru -- ri -- le L-a lu -- crat.
  De ti-- ne se __ bu -- cu -- ră, ce -- ea ce eşti 
  pli -- nă de har, toa -- tă făp -- tu -- ra, 
  Sla -- vă, sla -- vă ţi -- e, sla -- vă ţi -- e! __
}

tenorWords = \lyricmode {
  De ti -- ne se bu -- cu -- ră, ce -- ea ce eşti pli -- nă de har, 
  toa -- tă făp -- tu -- ra.
  şi nea -- mul o -- me -- nesc,
  Ce -- ea ce eşti bi -- se -- ri -- că sfin -- ţi -- tă 
  şi rai cu -- vân -- tă -- tor,
  La -- u -- da fe -- cio -- ri -- ei, din ca -- re 
  Dum -- ne -- zeu, Dum -- ne -- zeu S-a în -- tru -- pat.
  Cel ce es -- te mai 'na -- in -- te de veci, 
  Dum -- ne -- ze -- ul nos -- tru. 
  Că mi -- tra -- sul tău sca -- un L-a fă -- cut
  şi pân -- te -- ce -- le tău mai des -- fă -- tat 
  de -- cât Ce -- ru -- ri -- le L-a lu -- crat.
  De ti-- ne se bu -- cu -- ră, ce -- ea ce eşti 
  pli -- nă de har, toa -- tă făp -- tu -- ra, 
  Sla -- vă, sla -- vă ţi -- e, sla -- vă ţi -- e! __
}

bassWords = \lyricmode {
  \skip 1 \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1 \skip 1 
}

sopMusic = \relative c'' {
  gis4^\p
  b a gis8([ a]) b4 a gis a8([ gis]) a4 a gis2. a8([ gis]) a4 a gis2. 
  a4^\markup "dim. rall." a gis8([ fis]) gis4.( fis8) e4 \fermata
  fis4^\p b^\markup " Solo" gis^\markup "a tempo"
  e4(^\< a\!) gis4^\> fis2\!
  fis4^\markup "Tutti" gis(^\< a) b\!
  cis8([^\> b] gis4) fis\! e2 r4
  fis2 eis8 eis fis2 gis4 a4.^\p a8 gis gis fis4 fis \breathe 
  b4 b4. a8 gis a b2 r4
  a4^\p a8 a gis gis fis4 fis^\markup" cresc."
  e8([ gis]) b4. b8 a a gis2^\mf
  fis8 a gis4.^\f gis8 fis fis e4. r8
  gis8([^\p a])^\markup "Solo" b2 a8([ b])^\< cis2( b4)\!^\> 
  a2 gis8([\! ais]) b2 b8^\p^\< b ais4 ais ais8 ais\!
  a4 a a gis2. 
  fis4(^\< gis) a\! gis2 gis4 fis4.(^\> gis8 fis4) e2.\!
  fis2.^\pp g4^\markup "poco acceler." fis g a2.
  b4.( a8) g4 a4.( g8) fis4 g2
  a4 b4. b8 a b c4. c8 b b a2 b4 g4( a b)
  c4.^\mf c8^\markup "rall." b b \bar "||"
  \time 4/4
  ais2.^\accent ais4
  \time 3/4
  b2^\f \fermata gis4^\p
  b4 a gis8([ a]) b4 a gis a^\mf^\> a a gis2.\!
  b4^\> b b a2.\! fis4^\< gis a gis( a) b\!
  cis4^\f( b) a gis2 gis4 fis4.(^\> gis8 fis4) e2.\!
  e2^\pp e4 e2( dis4) e2.( e4) r4 r    
  \bar "|."
}

altMusic = \relative c' {
  e4 e e e e e e e e e e2. e4 e e e2.
  e4 fis8([ e]) dis4 e4.( dis8) e4
  dis dis e cis( fis) e
  dis2 dis4 e2 e4 e8([ fis] e4) dis e2 r4
  dis2 cis8 cis dis2 e4 fis4. fis8 e e dis4 dis 
  fis e4. e8 e e dis2 r4 fis4 fis8 fis e e dis4 dis
  e4 gis4. gis8 fis fis eis2 fis8 fis
  e4. e8 dis dis e4. r8
  e8([ fis]) gis2 fis8([ gis]) a2( gis4) fis2 e4 dis2
  dis8 dis e4 e e8 e fis4 fis fis e2.
  e2 fis4 e2 e4 dis2. e
  dis e4 dis e fis2. g4.( fis8) e4 fis4.( e8) dis4
  e2 fis4 g4. g8 fis g a4. a8 g g fis2 fis4 e2.
  e4. e8 e e e4( fis2) e4 dis2 e4
  e4 e e e e e e e e e2.
  eis4 eis gis fis2. dis4 e fis e2 e4
  e4( eis) fis e2 e4 dis2. e cis2 cis4 b2. b( b4) r r
}

tenorMusic = \relative c' {
  b4 b b b b b b cis8([ b]) cis4 cis b2. cis8([ b]) cis4 cis b2.
  cis4 cis b
  <<
      { 
        \voiceOne
        b4.( cis8) b4
      }
      \new Voice = "split" {
        \voiceTwo
        b4.( a8) gis4
      }
  >>
  \oneVoice
  r2. r r4 r
  cis4 b( a) gis a8([ cis] b4) a gis2 r4
  b4 b b b2 b4 b4. b8 b b b4 b
  dis cis4. cis8 cis cis fis,2 r4
  b4 b8 b b b b4 b
  b4 cis4. cis8 cis cis cis4 cis cis
  b4. b8 a a gis4. r8 r4 r2. r r r4 r
  fis8 fis fis4 fis fis8 fis b4 b b b2.
  cis4( b) cis b2 b4 a2. gis
  b b4 b b b2. b2 b4 b2 b4
  b2 d4 d4. d8 d d d4. d8 d d d2 b4 b2.
  a4. a8 b b cis2. cis4 fis,2 b4
  b4 b b b b b cis cis cis b2.
  cis4 cis cis cis2. b4 b b b2 d4
  cis2 cis4 b2 b4 a2. gis a2 a4
   <<
      { 
        \voiceOne
        gis2( a4) gis2.( gis4)
      }
      \new Voice = "split" {
        \voiceTwo
        gis2( fis4) e2.( e4)
      }
  >>
  \oneVoice
  r4 r  
}

bassMusic = \relative c {
  e4 gis fis e8([ fis]) gis4 fis e a a, cis8([ dis])
  <<
      { %\autoBeamOff
        \voiceOne
        e2.
      }
      \new Voice = "split" { %\autoBeamOff
        \voiceTwo
        e4 b8 gis e4
      }
  >>
  \oneVoice
  a'4 a, cis
  <<
      { %\autoBeamOff
        \voiceOne
        e2.
      }
      \new Voice = "split2" { %\autoBeamOff
        \voiceTwo
        e4 b8 gis e4
      }
  >>
  \oneVoice
  a8([ gis]) fis4 b e2 e,4 r2. r r4 r
  b'4 e( cis) b a( b) b <e e,>2 r4
  b4 b b b2 b4 b dis e8 gis b4 b,
  b8([ dis]) fis4 fis,4 fis8 fis b2 r4
  b4 dis8 dis e gis a4 a
  gis8([ e]) cis4 eis gis8 a b2
  a8 fis b4 b b,8 b e4. r8 r4 r2. r r r4 r
  b8 b cis4 cis cis8 cis dis4 dis dis e2.
  a4( gis) fis b2 b4 b,2. <e e,>
  b b4 b b b2. b2 b4 b2 b4 
  e2 d4 g4. g8 d g fis4. fis8 g g d2 dis4 e4( fis g)
  a4. a8 g g fis2. fis,4 b2 e4
  gis4 fis e8([ fis]) gis4 fis e a a, cis8([ dis])
  <<
      { %\autoBeamOff
        \voiceOne
        e2.
      }
      \new Voice = "split3" { %\autoBeamOff
        \voiceTwo
        e4 b8 gis e4
      }
  >>
  \oneVoice
  cis'4 cis dis8([ eis])
  <<
      { %\autoBeamOff
        \voiceOne
        fis2.
      }
      \new Voice = "split4" { %\autoBeamOff
        \voiceTwo
        fis4 cis8 a fis4
      }
  >>
  \oneVoice
  b4 b b e( fis) gis
  a4( gis) fis b2 b4 b,2. e a,2 a4 b2. e,2.( e4) r r  
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      \set Staff.instrumentName = #"S" 
      \new Voice { \global \sopMusic }
      \addlyrics { \womenWords }
    >>
    
    \new Staff <<
      \set Staff.instrumentName = #"A" 
      \new Voice { \global \altMusic }
      %\addlyrics { \womenWords }
    >>
    
    \new Staff <<
      \set Staff.instrumentName = #"T" 
      \clef "G_8"
      \new Voice { \global \tenorMusic }
      \addlyrics { \tenorWords }
    >>

    \new Staff <<
      \set Staff.instrumentName = #"B" 
      \clef bass
      \new Voice { \global \bassMusic }
      %\addlyrics { \bassWords }
      \new Lyrics \lyricsto "split" { ce -- ea ce eşti }
      \new Lyrics \lyricsto "split2" { pli -- nă de har, }
      \new Lyrics \lyricsto "split3" { ce -- ea ce eşti }
      \new Lyrics \lyricsto "split4" { pli -- nă de har, }
    >>
  >>
>>

midiOutput = \midi {
    \tempo 4 = 40
    \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \myScore
  \layout { }
}

\score {
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}
